# -*- coding: utf-8 -*-
"""
Created on Thu Mar 18 11:53:20 2021

@author: reinoutubbink
"""

import numpy as np
import matplotlib.pyplot as plt
import glob
import os

#constants needed for plotting
plt.close('all')
#os.chdir('C:\\Raw_data\\SIM_data\\Results\\Dyn-0.1M\\EXP')
voltage = np.loadtxt('Voltage.csv')
totalV = (max(voltage)-min(voltage))*2

currents = []
scanrates = []

for filename in glob.glob('CV*.csv'):
   with open(os.path.join(os.getcwd(), filename), 'r') as f: # open in readonly mode
       curtemp = np.loadtxt(f, delimiter = '\t')
       currents.append(curtemp)
       scanrate = float(filename[2:-4])/1000
       scanrates.append(scanrate)

del currents[8]
del scanrates[8]
       
Curnum = len(currents)
times = []

for i in range(Curnum):
    time = np.linspace(0,1000*totalV/scanrates[i],len(currents[i]))
    times.append(time)

electrons = []
electronsc = []
totale = 0
for i in range(Curnum):
    injected = []
    injectedc = []
    Sum = 0
    tincr = times[i][10] - times[i][9]
    for j in range(0,len(currents[i])):
        Sum += tincr*-currents[i][j][1]
        injected.append(Sum)
        injectedc.append(Sum + totale)
    electrons.append(injected)
    electronsc.append(injectedc)
    totale = electronsc[-1][-1]

cmap = plt.get_cmap('Blues')
colors = [cmap(i) for i in np.linspace(0, 1, Curnum+1)]


J0 = []
x = np.linspace(scanrates[0],scanrates[-1],Curnum)


plt.figure('CV comparison EXP')
for i in range(Curnum):#start at 5 for paper figure?
    plt.plot(currents[i][:,0]-0.3,currents[i][:,1]*1e3, color=colors[i])
    J0.append(max(currents[i][:,1]))
    
    

plt.xlabel('Voltage (V)', size = '15')                              
plt.ylabel('Current density/scan rate (mA/cm^2)', size = '15')
plt.tick_params(labelsize='25',length=8,width=2)
plt.ylim([-3,2.5])
plt.xlim([-1.35,-0.25])
fig = plt.gcf()
fig.set_size_inches(10, 6, forward=True)
plt.show
   
  #%%
fig1 = plt.figure('scan rate vs maximum current')
ax1 = fig1.add_subplot(1,1,1)
plt.scatter(scanrates[:],J0,color='k', marker='o')
plt.plot(x,x/270,'b--')
plt.plot(x,x**0.5/460,'k--')
plt.yscale('log')
plt.xscale('log')
plt.xlim([0.09,1.2])
plt.ylim([3e-4,5e-3])
ax1.tick_params(length=7, width=2,labelsize='20')
ax1.margins(x=0.01,y=0.1)
fig = plt.gcf()
fig.set_size_inches(5, 3.5, forward=True)
plt.tight_layout()

#RS calculation of the Diffusion coefficient
mobs = []
for i in range(Curnum):
    mobs.append(1.39e-11*(J0[i]/0.1)**2/scanrates[i]*38.68)

plt.figure('Mobilities')    
plt.scatter(scanrates,mobs,color='k', marker='o')
plt.xlabel('Scan rate (V/s)', size = '15')                              
plt.ylabel('Mobilities (m2V-1s-1)', size = '15')
plt.ylim([0,1e-12])
plt.show()

#%% ODC
D = 1.7e-5
C = 6e25
mob = 1e-9 #solution mobility of ions
q = 1.6022e-19
ODC = D / (C*mob)/q * 10000 #in V/(A/cm2)

Corvolt = []
for i in range(Curnum):
    Cor = []
    for j in range(len(currents[i])):
        Cor.append(currents[i][j][0] - currents[i][j][1]*ODC)
    Corvolt.append(Cor)
        
plt.figure('CV comparison corrected')
for i in range(Curnum-4,Curnum):
    plt.plot(Corvolt[i],currents[i][:,1]*1e3, color=colors[-i-1])

#%% extraction analysis
extracted = []
for i in range(Curnum):
    half = int(len(currents[i])/2)
    Injection = sum(currents[i][:half])
    Extraction = sum(currents[i][half:])
    extracted.append(-Extraction/Injection*100)
    
plt.figure('extraction comparison')
plt.plot(scanrates,extracted)
plt.xlabel('Scan rate (V/s)', size = '15')                              
plt.ylabel('extraction (%)', size = '15')